<!DOCTYPE html>
<html>
<body>
<?php

  include "API.php";

  if (isset($_REQUEST["submit"]))  // page loaded via submit button
  {

    // split out date and tourney name from selected value

    $tourney = stripslashes($_REQUEST["tourney"]);
    $trdate = Substr($tourney, 0, 10);
    $trname = Substr($tourney, 12);

    echo $tourney . "<br/>";

    // retrieve file

    $params = array("Command" => "TournamentsResults", "Date" => $trdate, "Name" => $trname);
    $api = Poker_API($params);

    // check for error

    if ($api -> Result == "Error") die($api -> Error);

    // display results

    echo "<pre>\n";
    for ($i = 0; $i < count($api -> Data); $i++) echo $api -> Data[$i] . "\n";
    echo "</pre>\n"; 
  }
  else   // initial page load
  {

    // retrieve list of files

    $params = array("Command" => "TournamentsResults");
    $api = Poker_API($params);

    // check for error

    if ($api -> Result == "Error") die($api -> Error);

    // fill droplist with dates and tourney names

    $count = $api -> Files;
    echo "<h3>Tournament Results</h3>\n";
    echo "<form method='post'>\n";
    echo "<select name='tourney'>\n";
    for ($i = 0; $i < $count; $i++)
    {
      $tr = $api -> Date[$i] . "  " . htmlspecialchars($api -> Name[$i], ENT_QUOTES);
      echo "<option value='" . $tr . "'>" . $tr . "</option>\n";
    } 

    // submit button reloads page with selected file info

    echo "</select> &nbsp; <input type='submit' name='submit' value='Submit'>\n";
    echo "</form>\n";
    echo "<p>Files found: " . $count . "</p>\n";
  }

?>
</body>
</html>
