<!DOCTYPE html>
<html>
<body>

  <?php
    if (isset($_REQUEST["Search"]))   // page load via search button
    {
      include "API.php";
  
      // get player name submitted by form

      $player = $_REQUEST["Player"];        
      if ($player == "")
      {
        echo "<b>No player name entered. Click the back button.</b><br/>";
        exit;
      } 

      // get list of connections 

      $params = array("Command" => "ConnectionsList", "Fields" => "Player");
      $api = Poker_API($params);
      if ($api -> Result == "Error")
      {
        echo "Error: " . $api -> Error . "<br/>";
        exit;
      }

      // loop thru connections list looking for player

      $found = false; 
      $connections = $api -> Connections;
      for ($i = 0; $i < $connections; $i++)        
      {
        if (strcasecmp($player, $api -> Player[$i]) == 0)
        {
          $found = true;
          break;
        }
      }
      echo "<b>" . $player . " is ";
      if ($found != true) echo "not ";
      echo "logged in</b><br/>";

      // get list of ring games

      echo "<br/><b>Ring Games</b><br/>";
      $params = array("Command" => "RingGamesList", "Fields" => "Name");
      $api = Poker_API($params);
      if ($api -> Result == "Error")
      {
        echo "Error: " . $api -> Error . "<br/>";
        exit;
      }

      // loop thru ring games list looking for player

      $found = 0;
      $rcount = $api -> RingGames;
      for ($i = 0; $i < $rcount; $i++)
      {

        $r = $api -> Name[$i];

        // fetch waiting
   
        $params = array("Command" => "RingGamesWaiting", "Name" => $r);
        $api2 = Poker_API($params);
        $pcount = $api2 -> Count;

        // loop thru waiting list

        for ($j = 0; $j < $pcount; $j++)
        {
          if (strcasecmp($player, $api2 -> Wait[$j]) == 0)
          {
            $found++;
            echo "In waiting list for " . $r . "<br/>";
            break;
          }
        }

        // fetch players
 
        $params = array("Command" => "RingGamesPlaying", "Name" => $r);
        $api2 = Poker_API($params);
        $pcount = $api2 -> Count;

        // loop thru players list

        for ($j = 0; $j < $pcount; $j++)
        {
          if (strcasecmp($player, $api2 -> Player[$j]) == 0)
          {
            $found++;
            echo "Seated at " . $r . "<br/>";
            break;
          }
        }
      }
      if ($found == 0) echo "(none)<br/>";

      // get list of tournaments

      echo "<br/><b>Tournaments</b><br/>";
      $params = array("Command" => "TournamentsList", "Fields" => "Name");
      $api = Poker_API($params);
      if ($api -> Result == "Error")
      {
        echo "Error: " . $api -> Error . "<br/>";
        exit;
      }

      // loop thru tournaments list looking for player

      $found = 0;
      $tcount = $api -> Tournaments;
      for ($i = 0; $i < $tcount; $i++)
      {

        $t = $api -> Name[$i];

        // fetch waiting

        $params = array("Command" => "TournamentsWaiting", "Name" => $t);
        $api2 = Poker_API($params);
        $pcount = $api2 -> Count;

        // loop thru waiting list

        for ($j = 0; $j < $pcount; $j++)
        {
          if (strcasecmp($player, $api2 -> Wait[$j]) == 0)
          {
            $found++;
            echo "In waiting list for " . $t . "<br/>";
            break;
          }
        }

        // fetch players  

        $params = array("Command" => "TournamentsPlaying", "Name" => $t);
        $api2 = Poker_API($params);
        $pcount = $api2 -> Count;

        // loop thru players list

        for ($j = 0; $j < $pcount; $j++)
        {
          if (strcasecmp($player, $api2 -> Player[$j]) == 0)
          {
            $found++;
            echo "Seated at " . $t . " - Table " . $api2 -> Table[$j] . "<br/>";
            break;
          }
        }
      }
      if ($found == 0) echo "(none)<br/>";
      echo "<br/><b>Click the back button for another search</b><br/>";
      exit;
    }
  ?>

  <!-- display input form on first load  -->
  <!-- post results back to same page -->

  <h3>Search for Player</h3>
  <form method="post">
    Screen name:<br/>
    <input type="text" name="Player" />
    <input type="submit" name="Search" value="Search" />
  </form>

</body>
</html>
