<!DOCTYPE html>
<html>
<body>
<?php

  include "API.php";

  // retrieve event log dates into $edates array

  $params = array("Command" => "LogsEvent");
  $api = Poker_API($params);
  if ($api -> Result == "Error") die($api -> Error);
  $count = $api -> Files;
  $edates = array();
  for ($i = 0; $i < $count; $i++) $edates[] = $api -> Date[$i];
 
  if (isset($_REQUEST["stats"]))  // parse selected event logs
  {

    function addrecord()  // add a record representing a server session
    {
      global $playerlist, $starttime, $stoptime, $logins, $peaklogins;
      $unique = count($playerlist); 
      echo "<tr><td>$starttime</td><td>$stoptime</td><td>$logins</td><td>$unique</td><td>$peaklogins</td></tr>\n";
    }

    function resetstats()  // new session
    {
      global $playerlist, $starttime, $stoptime, $logins, $currentlogins, $peaklogins;
      $logins = 0;
      $currentlogins = 0; 
      $peaklogins = 0;
      $playerlist = array();
      $starttime = "?";
      $stoptime = "?";
    }

    $edate1 = $_REQUEST["edate1"];
    $edate2 = $_REQUEST["edate2"];
    if ($edate1 > $edate2) die("Starting date is greater than ending date. Click the Back button.");

    // loop through event files and merge into $events array

    $events = array(); 
    for ($i = $edate1; $i <= $edate2; $i++)
    {
      $params = array("Command" => "LogsEvent", "Date" => $edates[$i]);
      $api = Poker_API($params);
      if ($api -> Result == "Error") die($api -> Error);
      $events = array_merge($events, $api -> Data);
    }

    resetstats();
    $title = "Logins " . $edates[$edate1];
    if ($edate1 != $edate2) $title = $title . " to " . $edates[$edate2];
    echo "<table cellpadding='5' border='1'>\n";
    echo "<tr><th colspan='5'>$title</th></tr>\n";
    echo "<tr><th>Start</th><th>Stop</th><th>Logins</th><th>Unique</th><th>Peak</th></tr>\n";

    // loop through event lines

    foreach ($events as $line)
    {
      if (strpos($line,"System|Game server started") !== false)
      {
        $starttime = substr($line,0,19);
      }
      elseif (strpos($line,"System|Game server stopped") !== false)
      {
        $stoptime = substr($line,0,19);
        addrecord();
        resetstats();
      }
      elseif (strpos($line," logged into session ") !== false)
      {
        $logins++;
        $currentlogins++;
        if ($currentlogins > $peaklogins) $peaklogins = $currentlogins;
        $p = strpos($line," logged into session ");
        $player = substr($line,26,$p-26);
        $playerlist[$player] = true;
      }
      elseif (strpos($line," logged out") !== false)
      {
        if ($currentlogins > 0) $currentlogins--;
      }
    }
    if ($starttime != "?") addrecord();
    echo "<tr><th colspan='5'>Records parsed: " . count($events) . "</th></tr>\n";
    echo "</table><br/>\n";
  }
  else  // initial page load - display selection droplists
  {

    echo "<h3>Login Stats</h3>\n";
    echo "<p>Event files found: " . $count . "</p>\n";

    // display droplist of dates

    echo "<form method='post'>\n";
    echo "Start date: <select name='edate1'>\n";
    foreach ($edates as $i => $e) echo "<option value='" . $i . "'>" . $e . "</option>\n";
    echo "</select> &nbsp; ";

    echo "End date: <select name='edate2'>\n";
    foreach ($edates as $i => $e) echo "<option value='" . $i . "'>" . $e . "</option>\n";
    echo "</select> &nbsp; ";

    // submit button reloads page with selected event log dates

    echo "<input type='submit' name='stats' value='Submit'>\n";
    echo "</form>\n";
  }

?>
</body>
</html>
