<!DOCTYPE html>
<html>
<body>
<?php

  include "API.php";

  if (isset($_REQUEST["submit"]))  // page loaded via submit button
  {

    // split out date and table name from selected value

    $history = stripslashes($_REQUEST["history"]);
    $hhdate = Substr($history, 0, 10);
    $hhname = Substr($history,12);  

    // retrieve file

    $params = array("Command" => "LogsHandHistory", "Date" => $hhdate, "Name" => $hhname);
    $api = Poker_API($params);

    // check for error

    if ($api -> Result == "Error") die($api -> Error);

    // display results

    echo "<pre>\n";
    for ($i = 0; $i < count($api -> Data); $i++) echo $api -> Data[$i] . "\n";
    echo "</pre>\n"; 
  }
  else   // initial page load
  {

    // retrieve list of files

    $params = array("Command" => "LogsHandHistory");
    $api = Poker_API($params);

    // check for error

    if ($api -> Result == "Error") die($api -> Error);

    // fill droplist with dates and table names

    $count = $api -> Files;
    echo "<h3>Hand History</h3>\n";
    echo "<form method='post'>\n";
    echo "<select name='history'>\n";
    for ($i = 0; $i < $count; $i++)
    {
      $hh = $api -> Date[$i] . "  " . htmlspecialchars($api -> Name[$i], ENT_QUOTES);
      echo "<option value='" . $hh . "'>" . $hh . "</option>\n";
    } 

    // submit button reloads page with selected file info

    echo "</select> &nbsp; <input type='submit' name='submit' value='Submit'>\n";
    echo "</form>\n";
    echo "<p>Files found: " . $count . "</p>\n";
  }

?>
</body>
</html>
