<!DOCTYPE html>
<html>
<body>
<?php

  $topcount = 10;  // display top 10, use any number you like

  include "API.php";

  // Fetch the Site Name using the SystemGet API command.

  $params = array("Command" => "SystemGet", "Property" => "SiteName");
  $api = Poker_API($params);
  $result = $api -> Result;
  if ($result == "Error") die("Error: " . $api -> Error);
  $sitename = $api -> Value;

  // Fetch the list of players using the AccountsList API command.

  $params = array("Command" => "AccountsList", "Fields" => "Player,Balance");
  $api = Poker_API($params);
  $result = $api -> Result;
  if ($result == "Error") die("Error: " . $api -> Error);

  // Iterate through the players in the response and create a associative
  // chips array keyed on player name.

  $accounts = $api -> Accounts;
  $chips = array();
  for ($i = 0; $i < $accounts; $i++)
  {
    $player = $api -> Player[$i];
    $chips[$player] = $api -> Balance[$i];
  }

  // Sort array in decending order.

  arsort($chips);

  // Display results in an html table.

  echo "<table border='1' cellpadding='5'>\r\n";
  echo "<tr><th colspan='3'>$sitename - Chip Leaders</th></tr>\r\n";
  echo "<tr><th>Rank</th><th>Player</th><th>Balance</th></tr>\r\n";
  $rank = 0;
  foreach ($chips as $p => $c)
  {
    $rank++;
    echo "<tr><td>$rank</td><td>$p</td><td>$c</td></tr>\r\n";
    if ($rank == $topcount) break;
  }
  echo "</table><br>\r\n";

?>
</body>
</html>
